<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Entity extends Model 
{

    protected $table = 'entities';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'acronym');

    public function checkings()
    {
        return $this->hasMany('App\Models\Checking');
    }

    public function agents()
    {
        return $this->hasMany('App\Models\Agent');
    }

}